﻿#include  "StdAfx.h"

#include  "CommandProcessorState.hpp"
#include  <szRuntimeException.hpp>
#include  <szString.hpp>
#include  <szPath.hpp>
#include  <buffers.hpp>

using namespace szpp;

CommandProcessorState::CommandProcessorState(ProcessUI *pUI) :
  pUI(pUI),
  quitEvent(), doneEvent(),
  inputPathRoot(), outputPathRoot(),
  log(),
  passwordUI(pUI),
  verbose(false)
{
  sbuf<szchar, MAX_PATH> buf;
  if (0 == GetCurrentDirectory(buf.size(), buf))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get the current directory info")) << last_error_info(GetLastError()));

  inputPathRoot.assign(buf);
  outputPathRoot.assign(buf);
}

CommandProcessorState::~CommandProcessorState()
{
}

void CommandProcessorState::AddLog(const szpp::RuntimeException &runtimeException)
{
  szstring logMessage = Format(SZL("%s: %s"), SZT("Error"), runtimeException.GetDescription().c_str());

  char const * const *func = boost::get_error_info<boost::throw_function>(runtimeException);
  char const * const *file = boost::get_error_info<boost::throw_file>(runtimeException);
  int const *line = boost::get_error_info<boost::throw_line>(runtimeException);

  if (u32 const *last_error = boost::get_error_info<last_error_info>(runtimeException))
    logMessage.append(Format(SZT(", Error code=0x%X"), *last_error));
  
  // ソースの行とか関数まで表示するのはデバッグ目的なので、詳細を記録するオプションが指定されているときだけ。
  if (verbose && 0 != func && 0 != file && 0 != line)
  {
    const szstring funcStr = ToSzstring(*func);
    const szstring fileStr = ExtractFileName(ToSzstring(*file));

    logMessage.append(Format(SZT(", File=%s, Line=%d, Func=%s"), fileStr.c_str(), *line, funcStr.c_str()));
  }

  AddLog(logMessage);
}

int CommandProcessorState::GetPassword(const szstring &archive, szstring *password)
{
  return passwordUI.GetPassword(archive, password);
}
